create or replace package tbicds.PCK_REPORTS
AUTHID CURRENT_USER 
is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
 --type defs to return recordsets
  type RetRefCursor is ref cursor;
  type refCursor is ref cursor;
 
  --constants
  c_nSUBJECTIVE  constant number := 1;
  c_nOBJECTIVE   constant number := 2;
  c_nASSESSMENT  constant number := 3;
  c_nPLAN        constant number := 4;
  c_nREVIEW      constant number := 5;
  c_nOTHER       constant number := 6;
   
  c_nBETTER      constant number := 1;
  c_nSAME        constant number := 2;
  c_nWORSE       constant number := 3;

/*loads a temp table with population matching criteria*/  
procedure LoadPopulation (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_dtFrom                 in date,      
      pi_dtTo                   in date,
      pi_nClinicalSetting       in number,
     
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      pi_nCPAID                 in number,
      
      pi_nImpairmentID          in number,
      pi_nInjuryID              in number,
      pi_nGender                in number,
      pi_nMilStatusID           in number,
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      );
      
  /*get rs of injuries*/
procedure GetInjuryRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );
      
/*get rs of impairments*/
  procedure GetImpairmentRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );
  
  /*get aggregate report given the module group id and mid*/
  procedure GetAggReportRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_nModuleGroupID         in number,
      pi_nMID                   in number,
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );

function GetImpairmentRID(pi_vPatientID in varchar2,
                          pi_dtEnd in date) return number;

function GetInjuryRID(pi_vPatientID in varchar2,
                          pi_dtEnd in date) return number;
                          
/*gets the admission intake id*/
function GetAdmissionIntakeID(pi_nMID in number,
                              pi_vPatientID in varchar2,
                              pi_dtStart in date,
                              pi_dtEnd in date)  return number;

/*get the discharge intake id*/                              
function GetDischargeIntakeID(pi_nMID in number,
                              pi_vPatientID in varchar2,
                              pi_dtStart in date,
                              pi_dtEnd in date)  return number;

/*get the followup instrument id*/                              
function GetFollowupIntakeID(pi_nMID in number,
                             pi_vPatientID in varchar2,
                             pi_nDischargeID in number) return number;                              
      

end PCK_REPORTS;
/

